/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.fabric;

import com.fizzware.dramaticdoors.fabric.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallSlidingDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallStableDoorBlock;
import com.fizzware.dramaticdoors.fabric.items.ModdedTab;
import com.fizzware.dramaticdoors.fabric.items.ShortDoorItem;
import com.fizzware.dramaticdoors.fabric.items.TallDoorItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class DDRegistry {
    public static final List<Pair<String, class_2248>> DOOR_BLOCKS_TO_REGISTER = new ArrayList<Pair<String, class_2248>>();
    public static final List<Pair<String, class_1792>> DOOR_ITEMS_TO_REGISTER = new ArrayList<Pair<String, class_1792>>();
    public static final class_1792.class_1793 PROPERTIES = new class_1792.class_1793();
    public static class_1761 MAIN_TAB = null;
    public static class_1761 CHIPPED_TAB = null;
    public static class_1761 MACAW_TAB = null;
    public static class_1761 MANYIDEAS_TAB = null;

    public static void registerTabs(ModdedTab tabSystem) {
        MAIN_TAB = tabSystem.createTab("dramaticdoors", () -> new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960("dramaticdoors", "tall_oak_door"))), null);
        CHIPPED_TAB = tabSystem.createTab("dramaticdoors_chipped", () -> new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960("dramaticdoors", "tall_chipped_gated_birch_door"))), "chipped");
        MACAW_TAB = tabSystem.createTab("dramaticdoors_macaw", () -> new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960("dramaticdoors", "tall_macaw_dark_oak_barn_door"))), "mcwdoors");
        MANYIDEAS_TAB = tabSystem.createTab("dramaticdoors_manyideas", () -> new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960("dramaticdoors", "tall_manyideas_crimson_blank_door"))), "manyideas_doors");
    }

    public static void registerVanilla() {
        DDRegistry.registerDoorBlockAndItem("tall_iron_door", "short_iron_door", class_2246.field_9973, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_oak_door", "short_oak_door", class_2246.field_10149, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_spruce_door", "short_spruce_door", class_2246.field_10521, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_birch_door", "short_birch_door", class_2246.field_10352, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_jungle_door", "short_jungle_door", class_2246.field_10627, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_acacia_door", "short_acacia_door", class_2246.field_10232, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_dark_oak_door", "short_dark_oak_door", class_2246.field_10403, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_mangrove_door", "short_mangrove_door", class_2246.field_37566, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_crimson_door", "short_crimson_door", class_2246.field_22102, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_warped_door", "short_warped_door", class_2246.field_22103, true, MAIN_TAB);
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, boolean includeShort, class_1761 tab) {
        class_2248 tempBlock = DDRegistry.createDoorBlock(block, true);
        class_1792 tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(block, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, class_4970.class_2251 properties, boolean includeShort, class_1761 tab) {
        class_2248 tempBlock = DDRegistry.createDoorBlock(properties, true);
        class_1792 tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(properties, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerSlidingDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, boolean includeShort, class_1761 tab) {
        class_2248 tempBlock = DDRegistry.createSlidingDoorBlock(block, true);
        class_1792 tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createSlidingDoorBlock(block, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerStableDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, boolean includeShort, class_1761 tab) {
        class_2248 tempBlock = DDRegistry.createStableDoorBlock(block, true);
        class_1792 tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createStableDoorBlock(block, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    protected static class_2248 createSlidingDoorBlock(class_2248 block, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw sliding doors are currently not supported.");
        }
        TallSlidingDoorBlock tempBlock = new TallSlidingDoorBlock(block);
        return tempBlock;
    }

    protected static class_2248 createStableDoorBlock(class_2248 block, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw stable doors are currently not supported.");
        }
        TallStableDoorBlock tempBlock = new TallStableDoorBlock(block);
        return tempBlock;
    }

    protected static class_2248 createDoorBlock(class_2248 block, boolean isTall) {
        class_2248 tempBlock = isTall ? new TallDoorBlock(block) : new ShortDoorBlock(block);
        return tempBlock;
    }

    protected static class_2248 createDoorBlock(class_4970.class_2251 properties, boolean isTall) {
        class_2248 tempBlock = isTall ? new TallDoorBlock(properties) : new ShortDoorBlock(properties);
        return tempBlock;
    }

    protected static class_1792 createDoorItem(class_2248 block, boolean isTall, class_1761 tab) {
        class_1747 tempItem = isTall ? new TallDoorItem(block, PROPERTIES.method_7892(tab)) : new ShortDoorItem(block, PROPERTIES.method_7892(tab));
        return tempItem;
    }

    public static class_2248 getBlockByKey(class_2960 loc) {
        return DDRegistry.getBlockByKey(loc, class_2246.field_10149);
    }

    public static class_2248 getBlockByKey(class_2960 loc, class_2248 fallback) {
        if (class_2378.field_11146.method_10250(loc)) {
            return (class_2248)class_2378.field_11146.method_10223(loc);
        }
        return fallback;
    }

    public static class_2248 getBlockFromResourceLocation(class_2960 resource) {
        return DDRegistry.getBlockFromResourceLocation(resource, class_2246.field_10149);
    }

    public static class_2248 getBlockFromResourceLocation(class_2960 resource, class_2248 fallback) {
        return class_2378.field_11146.method_17966(resource).orElse(fallback);
    }
}

